#include <iostream>
#include <bits/stdc++.h>
#include <cstdlib>
#define fi first
#define se second
#define INF 0x3f3f3f3f
using namespace std;

class Graph
{

    int v, nodeCount;
    list<int >* adj;
    pair<int,int>* nodes;
public:

    Graph(int V);

    int GetNodeCount();
    int GetWeight(int v);
    void BFS_imp(Graph* g1, int s);
    int GetLeaf();


    void AddEdge(int u, int v);
    void AddNode(int v, int w);
    void CountLeaves(list<int>* leaves);
    int RemoveNodeAndEdge(int v);
    void PrintGraph();
    int findLast();
};

Graph::Graph(int v)
{
    this->v = v;
    this->nodeCount = v;
    adj = (list<int>*) malloc(v*v*sizeof(int));
    adj = new list<int>[v];
    nodes = new pair<int,int>[v];
    for(int i = 0; i < v; i++)
    {
        nodes[v].se = 0;
    }
}

int Graph::GetWeight(int v)
{
    return nodes[v].fi;
}

int Graph::GetLeaf()
{
     for(int i = 0; i < v; i++)
    {
        if(nodes[i].se == 1)
            { return i; }
    }
    return 0;
}

void Graph::BFS_imp(Graph* g1, int s)
{
    vector<bool> visited(v);
    list<int> queue1;
    visited[s] = true;
    queue1.push_back(s);
    while(!queue1.empty())
    {
        s = queue1.front();
        g1->AddNode(s, nodes[s].fi);
        queue1.pop_front();
        list<int>::iterator j;
        for(j = adj[s].begin(); j!=adj[s].end(); j++)
        {
            int v1 = (*j);
            if(!visited[v1])
            {
                g1->AddEdge(s, v1);
                visited[v1] = true;
                queue1.push_back(v1);
            }
        }

    }
}


int Graph::GetNodeCount()
{
    return nodeCount;
}

//Exercise Usage

void Graph::AddNode(int v, int w)
{
    nodes[v].fi += w;
}

void Graph::AddEdge(int u, int v)
{
    adj[u].push_back(v);
    adj[v].push_back(u);
    nodes[u].se++;
    nodes[v].se++;
}

void Graph::CountLeaves(list<int>* leaves)
{
    for(int i = 0; i < v; i++)
    {
        if(nodes[i].se == 1)
            { leaves->push_back(i);}
    }
}

int Graph::RemoveNodeAndEdge(int v)
{

    nodes[v].se--;
    int u = adj[v].front();
    nodes[u].fi+= nodes[v].fi;
    adj[u].remove(v);
    adj[v].remove(u);
    nodes[u].se--;
    if(adj[u].empty()) nodes[u].se--;
    this->nodeCount--;
    if(nodes[u].se == 1) return u;
    else return -1;
}

void Graph::PrintGraph()
{
    for(int i = 0; i < v; i++)
    {
        cout << i << "      (" << nodes[i].fi << " " << nodes[i].se << ")\n";
    }
}

int Graph::findLast()
{
    for(int i = 0; i < v; i++)
    {
        if(nodes[i].se == -1)
            return i;
    }
    return 0;
}
//non graph methods
int solve(Graph *g, int v)
{

    list<int>* a = new list<int>;
    g->CountLeaves(a);
    while(g->GetNodeCount() > 1)
    {
        int lowVal = INF;
        int rv = -1;
        list<int>::iterator j;
        for(j = a->begin(); j != a->end(); j++)
        {
            int nv = (*j);
            int weight = g->GetWeight(nv);
            if(lowVal > weight) { lowVal = weight; rv = nv; };
            if(lowVal == weight)
                if(nv > rv) { lowVal = weight; rv = nv; }
        }
        a->remove(rv);
        int k = g->RemoveNodeAndEdge(rv);
        if(k != -1) a->push_back(k);
    }
    return g->findLast() + 1;
}
int main()
{
    int v;
    cin >> v;
    Graph g(v);
    for(int i = 0; i < v - 1; i++)
    {
        int v1, v2;
        cin >> v1 >> v2;
        g.AddEdge(v1 - 1, v2 - 1);
    }
    for(int i = 0; i < v; i++)
    {
        int k;
        cin >> k;
        g.AddNode(i, k);
    }

    int q;
    cin >> q;
    int answer[q];
    int leaf = g.GetLeaf();
    Graph *g1 = new Graph(v);
    g.BFS_imp(g1, leaf);

    answer[0] = solve(g1, v);
    for(int i = 0; i < q; i++)
    {
        g1 = new Graph(v);
        g.BFS_imp(g1, leaf);
        int val, vert;
        cin >> val >> vert;
        g1->AddNode(vert - 1, val);
        g.AddNode(vert - 1, val);
        answer[i + 1] = solve(g1, v);
    }
    for(int i = 0; i < q + 1; i++)
    {
        cout << answer[i] << "\n";
    }
    return 0;
}